#!/bin/sh

MASTER_PAGE_LOG_SETTINGS_RESULT_MSG=""
MASTER_PAGE_LOG_SETTINGS_RESULT_OK=0
MASTER_PAGE_LOG_SETTINGS_RESULT_ERROR=1

MASTER_PAGE_LOG_SETTINGS_RESULT_CODE=${MASTER_PAGE_LOG_SETTINGS_RESULT_ERROR}
MASTER_PAGE_LOG_SETTINGS_RESULT_ROLLING=0

function check_max_rotate() {
	local max_rotate=${1}
	
	debug_print "check if valid: $max_rotate ..."
	if ! $(is_integer_positive_and_valid "$max_rotate") ; then
		debug_print "invalid max_rotate: $max_rotate"
		warning "$MASTER_PAGE_LOG_SETTINGS_INVALID_ARGUMENT" "$max_rotate"
		return 1
	fi
	
	debuglog_max_rotate=$max_rotate
	debug_print "get debuglog_max_rotate from dialog: $debuglog_max_rotate"	
	return 0
}

function check_size_limit() {
	local size_limit=${1}
	
	debug_print "check if valid: $size_limit ..."
	if ! $(is_integer_positive_and_valid "$size_limit") ; then
		debug_print "invalid size_limit: $size_limit"
		warning "$MASTER_PAGE_LOG_SETTINGS_INVALID_ARGUMENT" "$size_limit"
		return 1
	fi
	
	debuglog_size_limit=$size_limit
	debug_print "get debuglog_size_limit from dialog: $debuglog_size_limit"	
	return 0
}

function check_output_file() {
	# no checking
	debuglog_output=${1}
	debug_print "get debuglog_output from dialog: $debuglog_output"
	return 0
}

function save_debug_configuration() {
	debug_print "in function '${FUNCNAME[0]}'"
    
    local msg
    msg=`/opt/TrendMicro/DTAS/ManagementServer/bin/sboxcmd/sboxcmd \
            debug \
            set-debug \
            --enable=${debuglog_enable} \
            --size-limit=${debuglog_size_limit} \
            --max-rotate=${debuglog_max_rotate} \
            --output=${debuglog_output}`
    local ret="${?}"
	if [ "${ret}" -ne 0 ]; then
        debug_print "SaveDebugConfigurationFail: ret='${ret}', msg='${msg}'"
        
        warning "${MASTER_PAGE_LOG_SETTINGS_INTERNAL_ERROR}" "${ret}" 
        return 1
    fi
}

master_page_log_settings() {
	debug_print 'in function "master_page_log_settings"'
	
	local form_data="\"$MASTER_PAGE_LOG_SETTINGS_MAX_ROTATE\"  1 1 \"$debuglog_max_rotate\" 1 40 3 2\
					 \"$MASTER_PAGE_LOG_SETTINGS_SIZE_LIMIT\"  3 1 \"$debuglog_size_limit\" 3 40 4 3\
					 \"$MASTER_PAGE_LOG_SETTINGS_OUTPUT_FILE\" 5 1 \"$debuglog_output\" 5 40 30 0"
	local form_height=5
	
	tp_form \
	"${MASTER_PAGE_LOG_SETTINGS_TITLE}" \
	"${MASTER_PAGE_LOG_SETTINGS_TEXT}" \
	"${MASTER_PAGE_LOG_SETTINGS_LABEL_OK}" \
	"${MASTER_PAGE_LOG_SETTINGS_LABEL_CANCEL}" \
	"$form_data" \
	$form_height
	
	# no error cases
	MASTER_PAGE_LOG_SETTINGS_RESULT_CODE=${MASTER_PAGE_LOG_SETTINGS_RESULT_OK}
	
	if [ "${TP_FORM_RESULT_CODE}" == "${TP_FORM_RESULT_CANCEL}" ]; then
		MASTER_PAGE_LOG_SETTINGS_RESULT_ROLLING=-1
		return
	fi
	
	# check inputs
	check_max_rotate `echo "$TP_FORM_RESULT_DATA" | sed -n '1p'`; 
	if [ $? -ne 0 ]; then
		MASTER_PAGE_LOG_SETTINGS_RESULT_ROLLING=0
		return
	fi
	check_size_limit `echo "$TP_FORM_RESULT_DATA" | sed -n '2p'`;
	if [ $? -ne 0 ]; then
		MASTER_PAGE_LOG_SETTINGS_RESULT_ROLLING=0
		return
	fi
	check_output_file `echo "$TP_FORM_RESULT_DATA" | sed -n '3p'`;
	if [ $? -ne 0 ]; then
		MASTER_PAGE_LOG_SETTINGS_RESULT_ROLLING=0
		return
	fi
	
	# save debug configuration
	save_debug_configuration
	local tmp_return_code=$?
	if [ "$tmp_return_code" -ne 0 ]; then
		debug_print "fail to save_debug_configuration: $tmp_return_code"
		MASTER_PAGE_LOG_SETTINGS_RESULT_ROLLING=0
		return
	fi
	
	MASTER_PAGE_LOG_SETTINGS_RESULT_ROLLING=-3 # back to master_page_esxi_conf
}
